/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Constraints Convenience Functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"

HRESULT GetMakeParallelInput(ISet **objectSet)
{
	START_METHOD("GetMakeParallelInput")

	HRESULT status = CONV_SUCCESS;


	double startX1 = -0.1;
	double startY1 = 0.1;
	double endX1 = 0.1;
	double endY1 = 0.1;

	double startX2 = -0.05;
	double startY2 = -0.05;
	double endX2 = 0.05;
	double endY2 = 0.05;

	double startX3 = 0.1;
	double startY3 = -0.1;
	double endX3 = 0.1;
	double endY3 = 0.08;

	double startX4 = -0.1;
	double startY4 = -0.13;
	double endX4 = 0.1;
	double endY4 = -0.13;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateLine(startX1, startY1, endX1, endY1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;
	status = CreateLine(startX2, startY2, endX2, endY2, &aLine2);
	CHECK_RETURN_STATUS(status)

	ILine *aLine3 = NULL;
	status = CreateLine(startX3, startY3, endX3, endY3, &aLine3);
	CHECK_RETURN_STATUS(status)

	ILine *aLine4 = NULL;
	status = CreateLine(startX4, startY4, endX4, endY4, &aLine4);

	ISet *objSet = NULL;
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Add line3 to the object set
	status = objSet->AddMember(aLine3);
	CHECK_RETURN_STATUS(status)

	// Add line4 to the object set
	status = objSet->AddMember(aLine4);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*objectSet = objSet;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeParallelInput")
}

HRESULT GetMakePerpendicularInput(ILine **line1, ILine **line2)
{
	START_METHOD("GetMakePerpendicularInput")

	HRESULT status = CONV_SUCCESS;

	double startX1 = -0.1;
	double startY1 = 0.1;
	double endX1 = 0.1;
	double endY1 = 0.1;

	double startX2 = -0.05;
	double startY2 = -0.05;
	double endX2 = 0;
	double endY2 = 0;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateLine(startX1, startY1, endX1, endY1, &aLine1);
	CHECK_RETURN_STATUS(status)
	
	ILine *aLine2 = NULL;
	status = CreateLine(startX2, startY2, endX2, endY2, &aLine2);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	ISet *pObjectSet = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&pObjectSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = pObjectSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = pObjectSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, pObjectSet));
	CHECK_RETURN_STATUS(status)

	*line1 = aLine1;
	*line2 = aLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakePerpendicularInput")
	
}

HRESULT GetMakeColinearInput(ISet **objectSet)
{
	START_METHOD("GetMakeColinearInput")

	HRESULT status = CONV_SUCCESS;

	ISet *objSet = NULL;

	double startX1 = -0.15;
	double startY1 = 0.1;
	double endX1 = -0.12;
	double endY1 = 0.1;

	double startX2 = -0.10;
	double startY2 = 0.08;
	double endX2 = 0.05;
	double endY2 = 0.08;

	double startX3 = 0.06;
	double startY3 = -0.1;
	double endX3 = 0.10;
	double endY3 = 0.08;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateLine(startX1, startY1, endX1, endY1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;
	status = CreateLine(startX2, startY2, endX2, endY2, &aLine2);
	CHECK_RETURN_STATUS(status)

	ILine *aLine3 = NULL;
	status = CreateLine(startX3, startY3, endX3, endY3, &aLine3);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Add line3 to the object set
	status = objSet->AddMember(aLine3);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*objectSet = objSet;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeColinearInput")
	
}

HRESULT GetMakeEqualLengthInput(ISet **objectSet)
{
	START_METHOD("GetMakeEqualLengthInput")

	HRESULT status = CONV_SUCCESS;

	ISet *objSet = NULL;

	double startX1 = -0.15;
	double startY1 = 0.1;
	double endX1 = -0.05;
	double endY1 = 0.1;

	double startX2 = 0.05;
	double startY2 = 0.05;
	double endX2 = 0.0;
	double endY2 = 0.0;

	double startX3 = 0.1;
	double startY3 = -0.1;
	double endX3 = 0.1;
	double endY3 = 0.08;

	double startX4 = -0.1;
	double startY4 = -0.13;
	double endX4 = 0.1;
	double endY4 = -0.13;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateLine(startX1, startY1, endX1, endY1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;	
	status = CreateLine(startX2, startY2, endX2, endY2, &aLine2);
	CHECK_RETURN_STATUS(status)

	ILine *aLine3 = NULL;
	status = CreateLine(startX3, startY3, endX3, endY3, &aLine3);
	CHECK_RETURN_STATUS(status)

	ILine *aLine4 = NULL;
	status = CreateLine(startX4, startY4, endX4, endY4, &aLine4);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Add line3 to the object set
	status = objSet->AddMember(aLine3);
	CHECK_RETURN_STATUS(status)

	// Add line4 to the object set
	status = objSet->AddMember(aLine4);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*objectSet = objSet;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeEqualLengthInput")
}

HRESULT GetFixLineInput(ISet **objectSet)
{

	START_METHOD("GetFixLineInput")

	HRESULT status = CONV_SUCCESS;

	ISet *objSet = NULL;

	double startX1 = -0.1;
	double startY1 = 0.1;
	double endX1 = 0.1;
	double endY1 = 0.1;

	double startX2 = -0.05;
	double startY2 = -0.05;
	double endX2 = 0.05;
	double endY2 = 0.05;

	double startX3 = 0.1;
	double startY3 = -0.1;
	double endX3 = 0.1;
	double endY3 = 0.08;

	double startX4 = -0.1;
	double startY4 = -0.13;
	double endX4 = 0.1;
	double endY4 = -0.13;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateLine(startX1, startY1, endX1, endY1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;
	status = CreateLine(startX2, startY2, endX2, endY2, &aLine2);
	CHECK_RETURN_STATUS(status)

	ILine *aLine3 = NULL;
	status = CreateLine(startX3, startY3, endX3, endY3, &aLine3);
	CHECK_RETURN_STATUS(status)

	ILine *aLine4 = NULL;
	status = CreateLine(startX4, startY4, endX4, endY4, &aLine4);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Add line3 to the object set
	status = objSet->AddMember(aLine3);
	CHECK_RETURN_STATUS(status)

	// Add line4 to the object set
	status = objSet->AddMember(aLine4);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*objectSet = objSet;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetFixLineInput")
}

HRESULT GetMakeTangentLineCircleInput(ILine **line1, ILine **circle1)
{
	START_METHOD("GetMakeTangentLineCircleInput")

	HRESULT status = NOERROR;

	ISet *objSet = NULL;

	double startX = -0.1;
	double startY = 0.1;
	double endX = 0.1;
	double endY = 0.1;

	double centerX = 0;
	double centerY = 0;
	double radius = 0.06;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateLine(startX, startY, endX, endY, &aLine1);
	
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;
	status = CreateCircle(centerX, centerY, radius, &aLine2);

	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*line1 = aLine1;
	*circle1 = aLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeTangentLineCircleInput")
	
}

HRESULT GetMakeTangentCircleCircleInput(ILine **circle1, ILine **circle2)
{
	START_METHOD("GetMakeTangentCircleCircleInput")

	HRESULT status = NOERROR;

	ISet *objSet = NULL;

	double centerX1 = 0.1;
	double centerY1 = 0.1;
	double radius1 = 0.04;

	double centerX2 = 0;
	double centerY2 = 0;
	double radius2 = 0.05;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateCircle(centerX1, centerY1, radius1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;
	status = CreateCircle(centerX2, centerY2, radius2, &aLine2);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*circle1 = aLine1;
	*circle2 = aLine2;

	status = CommitToProDESKTOP("Input"); 
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeTangentCircleCircleInput")
	
}

HRESULT GetMakeConcentricInput(ISet **objectSet)
{
	START_METHOD("GetMakeConcentricInput")
	
	HRESULT status = NOERROR;

	double centerX1 = 0.1;
	double centerY1 = 0.1;
	double radius1 = 0.04;

	double centerX2 = 0;
	double centerY2 = 0;
	double radius2 = 0.05;

	double centerX3 = -0.1;
	double centerY3 = -0.1;
	double radius3 = 0.03;

	double centerX4 = 0.05;
	double centerY4 = 0.05;
	double radius4 = 0.01;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateCircle(centerX1, centerY1, radius1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;	
	status = CreateCircle(centerX2, centerY2, radius2, &aLine2);
	CHECK_RETURN_STATUS(status)

	ILine *aLine3 = NULL;	
	status = CreateCircle(centerX3, centerY3, radius3, &aLine3);
	CHECK_RETURN_STATUS(status)

	ILine *aLine4 = NULL;
	status = CreateCircle(centerX4, centerY4, radius4, &aLine4);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	ISet *objSet = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Add line3 to the object set
	status = objSet->AddMember(aLine3);
	CHECK_RETURN_STATUS(status)

	// Add line4 to the object set
	status = objSet->AddMember(aLine4);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*objectSet = objSet;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeConcentricInput")
}

HRESULT GetMakeEqualRadiusInput(ISet **objectSet)
{
	START_METHOD("GetMakeEqualRadiusInput")

	HRESULT status = NOERROR;

	ISet *objSet = NULL;

	double centerX1 = -0.1;
	double centerY1 = -0.1;
	double radius1 = 0.04;

	double centerX2 = -0.1;
	double centerY2 = 0.1;
	double radius2 = 0.07;

	double centerX3 = 0.1;
	double centerY3 = -0.1;
	double radius3 = 0.03;

	double centerX4 = 0.1;
	double centerY4 = 0.1;
	double radius4 = 0.01;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;	
	status = CreateCircle(centerX1, centerY1, radius1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;	
	status = CreateCircle(centerX2, centerY2, radius2, &aLine2);
	CHECK_RETURN_STATUS(status)

	ILine *aLine3 = NULL;	
	status = CreateCircle(centerX3, centerY3, radius3, &aLine3);
	CHECK_RETURN_STATUS(status)

	ILine *aLine4 = NULL;
	status = CreateCircle(centerX4, centerY4, radius4, &aLine4);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Add line3 to the object set
	status = objSet->AddMember(aLine3);
	CHECK_RETURN_STATUS(status)

	// Add line4 to the object set
	status = objSet->AddMember(aLine4);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*objectSet = objSet;
	
	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeEqualRadiusInput")

}

HRESULT GetConstrainSizeInput(ILine **line)
{
	START_METHOD("GetConstrainSizeInput")

	HRESULT status = NOERROR;

	ILine *pLine = NULL;
	ISet *objSet = NULL;

	double startX = -0.05;
	double startY = -0.05;
	double endX = 0.05;
	double endY = 0.05;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	status = CreateLine(startX, startY, endX, endY, &pLine);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add the line to the object set
	status = objSet->AddMember(pLine);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*line = pLine;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetConstrainSizeInput")
}

HRESULT GetConstrainSeparationPointToPointInput(IPoint **point1, IPoint **point2)
{
	START_METHOD("GetConstrainSeparationPointToPointInput")
	
	HRESULT status = NOERROR;

	ISet *objSet = NULL;

	double startX = -0.05;
	double startY = -0.05;
	double endX = 0.05;
	double endY = 0.05;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateLine(startX, startY, endX, endY, &aLine1);
	CHECK_RETURN_STATUS(status)
		
	IPoint *startPoint = NULL;
	IPoint *endPoint = NULL;
	
	// Get the start point of the line
	status = aLine1->GetStartPoint(&startPoint);
	CHECK_RETURN_STATUS(status)

	// Get the end point of the line
	status = aLine1->GetEndPoint(&endPoint);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add the line to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*point1 = startPoint;
	*point2 = endPoint;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetConstrainSeparationPointToPointInput")
}

HRESULT GetConstrainSeparationPointToLineInput(IPoint **point1, ILine **line1)
{
	START_METHOD("GetConstrainSeparationPointToLineInput")
	
	HRESULT status = NOERROR;

	ISet *objSet = NULL;

	double startX1 = -0.1;
	double startY1 = 0.1;
	double endX1 = 0.1;
	double endY1 = 0.1;

	double startX2 = -0.05;
	double startY2 = -0.05;
	double endX2 = 0;
	double endY2 = 0;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	IPoint *startPoint = NULL;

	status = CreateLine(startX1, startY1, endX1, endY1, &aLine1) ;
	CHECK_RETURN_STATUS(status)

		// Get the start point of the line
	status = aLine1->GetStartPoint(&startPoint);
	CHECK_RETURN_STATUS(status)

	ILine *pLine2 = NULL;
	status = CreateLine(startX2, startY2, endX2, endY2, &pLine2) ;
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(pLine2);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*point1 = startPoint;
	*line1 = pLine2;

	status = CommitToProDESKTOP("Input");
	END_METHOD("GetConstrainSeparationPointToLineInput")
}

HRESULT GetConstrainSeparationLineToLineInput(ILine **line1, ILine **line2)
{
	START_METHOD("GetConstrainSeparationLineToLineInput")

	HRESULT status = NOERROR;

	ISet *objSet = NULL;

	double startX1 = -0.1;
	double startY1 = 0.1;
	double endX1 = 0.1;
	double endY1 = 0.1;

	double startX2 = -0.05;
	double startY2 = -0.05;
	double endX2 = 0.1;
	double endY2 = -0.05;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;	
	status = CreateLine(startX1, startY1, endX1, endY1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;
	status = CreateLine(startX2, startY2, endX2, endY2, &aLine2);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*line1 = aLine1;
	*line2 = aLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetConstrainSeparationLineToLineInput")
}

HRESULT GetMakeRadialDimInput(ILine **circle1)
{
	START_METHOD("GetMakeRadialDimInput")
	
	HRESULT status = NOERROR;

	ISet *objSet = NULL;

	double centerX = -0.02;
	double centerY = -0.02;
	double radius = 0.075;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *pLine = NULL;
	status = CreateCircle(centerX, centerY, radius, &pLine);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add the line to the object set
	status = objSet->AddMember(pLine);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*circle1 = pLine;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeRadialDimInput")
}

HRESULT GetMakeAngularDimInput(ILine **line1, ILine **line2)
{
	START_METHOD("GetMakeAngularDimInput")

	HRESULT status = NOERROR;

	ISet *objSet = NULL;

	double startX1 = -0.15;
	double startY1 = 0.1;
	double endX1 = -0.05;
	double endY1 = 0.1;

	double startX2 = 0.05;
	double startY2 = 0.05;
	double endX2 = 0.0;
	double endY2 = 0.0;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *aLine1 = NULL;
	status = CreateLine(startX1, startY1, endX1, endY1, &aLine1);
	CHECK_RETURN_STATUS(status)

	ILine *aLine2 = NULL;
	status = CreateLine(startX2, startY2, endX2, endY2, &aLine2);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objSet);
	CHECK_RETURN_STATUS(status)

	// Add line1 to the object set
	status = objSet->AddMember(aLine1);
	CHECK_RETURN_STATUS(status)

	// Add line2 to the object set
	status = objSet->AddMember(aLine2);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet));
	CHECK_RETURN_STATUS(status)

	*line1 = aLine1;
	*line2 = aLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMakeAngularDimInput")
}

HRESULT GetRemoveConstraintsInput(ISet **objectSet)
{
	START_METHOD("GetRemoveConstraintsInput")
	
	HRESULT status = NOERROR;

	ISet *rectangle1 = NULL;
	ISet *rectangle2 = NULL;
	ISet *objSet = NULL;

	double topLeftX1 = -0.1;
	double topLeftY1 = 0.1;
	double bottomRightX1 = 0.1;
	double bottomRightY1 = -0.1;

	double topLeftX2 = -0.08;
	double topLeftY2 = 0.08;
	double bottomRightX2 = 0.08;
	double bottomRightY2 = -0.08;

	status = CreateRectangle(topLeftX1, topLeftY1, bottomRightX1, bottomRightY1, &rectangle1) ;
	CHECK_RETURN_STATUS(status)

	status = CreateRectangle(topLeftX2, topLeftY2, bottomRightX2, bottomRightY2, &rectangle2) ;
	CHECK_RETURN_STATUS(status)

	//	status = rectangle1->AddSet(rectangle2);
	CHECK_RETURN_STATUS(status)

	*objectSet = rectangle1;

	END_METHOD("GetRemoveConstraintsInput")
}
